#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	
	
	[TestFixture]
	public class BOL_DonationType : BaseTest 
	{

		private DataTable _dtDonationType;
		private BOL.DonationType _tstDT;
		private byte[] rowVersion;
		private DataRow _drDonationType;
		

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				_dtDonationType = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM DonationType", true);

				this._drDonationType = _dtDonationType.Rows[0];
				rowVersion = (byte[])this._drDonationType[TABLES.DonationType.RowVersion];

				this.RefreshData = false;
			}

			_tstDT = new BOL.DonationType('0');
			_tstDT.SetInitialBrokenRules("frmBloodUnitMaintain");
		}


		[Test]
		public void Ctor_Char_Pass()
		{
			_tstDT = new BOL.DonationType('V');
			Assert.IsTrue(_tstDT != null);
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(BOL.BusinessObjectException))]
		public void Ctor_Char_Fail()
		{
			_tstDT = new BOL.DonationType(char.MinValue);
			Assert.IsTrue(_tstDT == null);
		}

		[Test]
		public void Ctor_Int_Pass()
		{
			int donationId = (int)this._drDonationType[TABLES.DonationType.DonationTypeId];

			BOL.DonationType tmpDT = new BOL.DonationType(donationId);

			Assert.IsNotNull(tmpDT);
			Assert.AreEqual(tmpDT.DonationTypeId , donationId);
		}

		[Test]
        [ExpectedException(typeof(Common.DataAccessLayerException))]
		public void Ctor_Int_Fail()
		{
			BOL.DonationType tmpDT = new BOL.DonationType(int.MinValue);
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			_tstDT = new BOL.DonationType(_drDonationType);
			Assert.IsTrue(_drDonationType[TABLES.DonationType.DonationTypeCode].ToString().Equals(_tstDT.DonationTypeCode.ToString()));
		}


		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void DonationTypeCode_Pass()
		{
			System.Char _DonationTypeCode;
			_DonationTypeCode = _tstDT.DonationTypeCode;
			Assert.AreEqual(_tstDT.DonationTypeCode,_DonationTypeCode);
		}

		[Test]
		public void DonationTypeCode_Fail()
		{
			System.Char _DonationTypeCode = 'V';
			_tstDT.DonationTypeCode = _DonationTypeCode;
			Assert.AreEqual(_tstDT.DonationTypeCode,_DonationTypeCode);
		}

		
		[Test]
		public void DonationTypeText_Pass()
		{
			System.String _DonationTypeText;
			_DonationTypeText = _tstDT.DonationTypeText;
			Assert.AreEqual(_tstDT.DonationTypeText,_DonationTypeText);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void DonationTypeText_Fail()
		{
		}

		[Test]
		public void DirectedType_Pass()
		{
			System.String _DirectedTypeCode;
			_DirectedTypeCode = _tstDT.DirectedType;
			Assert.AreEqual(_tstDT.DirectedType,_DirectedTypeCode);
		}

		[Test]
		public void DirectedType_Fail()
		{
			System.String _DirectedTypeCode = "Test";
			_tstDT.DirectedType = _DirectedTypeCode;
			Assert.AreEqual(_tstDT.DirectedType,_DirectedTypeCode);
		}

		[Test]
		public void GetDonationTypeByCode_Pass()
		{
			DataRow dr = BOL.DonationType.GetDonationTypeByCode('V');
			Assert.IsTrue(dr.ItemArray.Length > 0);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetDonationTypeByCode_Fail()
		{
			DataRow dr = BOL.DonationType.GetDonationTypeByCode(char.MinValue);
		}

		
		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow dr1 = this._dtDonationType.NewRow();

			DataRow dr2 = this._tstDT.LoadDataRowFromThis(dr1);

			Assert.AreEqual(dr1, dr2);	
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		[Test]
		public void SetDirectedType_Pass()
		{
			string type="A";
			
			char [] arType=type.ToCharArray();

			this._tstDT.SetDirectedType(arType[0]);

			Assert.AreEqual(this._tstDT.DirectedType, type);
		}

		
		[Test]
		public void SetDirectedType_Fail()
		{
			// invalid character
			char type='#';
			
			this._tstDT.SetDirectedType(type);

			Assert.IsTrue(this._tstDT.DirectedType!=type.ToString());
		}

		[Test]
		public void DonationTypeId_Pass()
		{
			Assert.IsNotNull(this._tstDT.DonationTypeId);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DonationTypeId_Fail()
		{
		}

		[Test]
		public void GetDonationTypeLookupDataTable_Pass()
		{
			DataTable dtTest = BOL.DonationType.GetDonationTypeLookupDataTable();

			Assert.AreEqual(3, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeId), TABLES.DonationType.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeCode), TABLES.DonationType.DonationTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDonationTypeLookupDataTable_Fail()
		{
		}

		[Test]
		public void GetDonationTypeLookupList_Pass()
		{
			ArrayList list=DonationType.GetDonationTypeLookupList();
			Assert.IsNotNull(list);
			Assert.IsTrue(list.Count>0);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDonationTypeLookupList_Fail()
		{
		}

		[Test]
		public void GetDonationTypeCodeById_Pass()
		{
			char tmpChar=DonationType.GetDonationTypeCodeById(1);

			Assert.IsTrue(tmpChar!=char.MinValue);
		}

		
		[Test]
		[ExpectedException(typeof(va.med.vbecs.Common.DataAccessLayerException))]
		public void GetDonationTypeCodeById_Fail()
		{
			// This should return the min value.
			char tmpChar=DonationType.GetDonationTypeCodeById(-11);

			Assert.AreEqual(tmpChar, char.MinValue);
		}
	}
}

#endif



